
                org $9000

                include "definitions.asm"

startProgram:
                ld    hl,0
                ld    (seed+1),hl

                call  INIT               ;initialize screen,sprites and sound

                ld    ix,MC
                ld    (ix+NPCS_DATA.CLR),15
                ld    (ix+NPCS_DATA.X),24h
                ld    (ix+NPCS_DATA.Y),9ch
                ld    (ix+NPCS_DATA.Xsize),8
                ld    (ix+NPCS_DATA.Ysize),16

                call  music_init

next_room:
                call  gen_maze
                call  npc_init


                xor a
                ld    (n_req+1),a

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; read keys
;
main:
                ld        a,8
                call      0141h
                ld        (kbd),a


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; MC update
;
                ld        hl,0
                ld        (cur_tile0),hl

                call      mc_update

                ld        hl,(cur_tile0)
                ld        a,h
                cp        SWITCH
                ret       z                ; hit GOAL

                ld        a,l
                cp        SWITCH
                ret       z                ; hit GOAL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; NPC update
;

                ld        b,NNPCS
                ld        iy,NPCs

1:              push      bc
                call      NPC_update

                ld        de,NPCS_DATA
                add       iy,de
                pop       bc
                djnz      1b

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; MSAT update

                ld        hl,MSAT
                ld        iy,MC

                ld        b,NNPCS+1

1:              call      update_MSAT

                ld        de,NPCS_DATA
                add       iy,de
                djnz      1b

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; SAT update

                ld      b,3
1:              push    bc
sfx:            call    no_sfx
                halt
                call    update_SAT
                pop     bc
                djnz    1b
                call    update_PNT

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; collision test

; MC collision
                ld      b,NNPCS+1

                ld      ix,MC
                ld      iy,NPCs

1:              exx
                ld      a,(iy+NPCS_DATA.STATUS)      ; do not test against explosions
                cp      5
                jr      z,2f

                ld      a,(iy+NPCS_DATA.CLR)         ; do not test against your own bullets
                cp      11
                jr      z,2f

                call    check_collision
                jp      c,mc_dies

2:
                ld      de,NPCS_DATA
                add     iy,de
                exx
                djnz    1b

; NPC collision

                ld      ix,NPCs                      ; point to bullets
                ld      b,NBLLTS

1:              push    bc                           ; For   i=NBULLTS:-1:1

                ld      iy,NPCs+NBLLTS*NPCS_DATA     ; point to robots
                ld      b,NRBTS

2:              push    bc                           ; For   j=NROBOTS:-1:1

                ld      a,(ix+NPCS_DATA.STATUS)      ; do not test inactive bullets
                and     a
                jr      z,next

                ld      a,(iy+NPCS_DATA.STATUS)      ; do not test exploding robots
                cp      5
                jr      z,next

                call    check_collision
                jp      nc,next

                ld      (iy+NPCS_DATA.COUNT),8
                ld      (iy+NPCS_DATA.STATUS),5      ; robot explodes
                ld      (iy+NPCS_DATA.CLR),8         ; color of the explosion
                ld      a,(iy+NPCS_DATA.X)
                sub     4
                ld      (iy+NPCS_DATA.X),a

                ld      (ix+NPCS_DATA.Y),212
                ld      (ix+NPCS_DATA.STATUS),0      ; bullet disappears
                call    explode                      ; SFX

next:
                ld      de,NPCS_DATA
                add     iy,de
                pop     bc
                djnz    2b                           ; Next  j

                add     ix,de
                pop     bc
                djnz    1b                           ; Next  i



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; exit
                ld      a,(kbd)    ; press DEL to Quit
                bit     3,a
                jp      nz,main

no_sfx:         ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; update MSAT
;


update_MSAT:
                ld   a,(iy+NPCS_DATA.Y)
                dec  a
                ld   (hl),a    ; Y
                inc  hl

                ld   c,0
                ld   a,(iy+NPCS_DATA.X)
                bit  7,(iy+NPCS_DATA.X+1)
                jr   z,1f
                add  a,32
                ld   c,128     ; EC bit
1:              ld   (hl),a    ; X
                inc   hl

                ld    a,(iy+NPCS_DATA.FRAME)
                add   a,a
                add   a,a
                ld    (hl),a    ; shape
                inc   hl

                ld   a,(iy+NPCS_DATA.CLR)
                or   c
                ld   (hl),a    ; color
                inc  hl

                ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; update SAT
;

                include satupd.asm

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; update PNT
;
update_PNT:
                ld    hl,PNT
                call  setwrt
                ld    hl,VMPNT+vroomsize/2
                ld    de,vroomsize-32
                ld    a,24
1:              ld    bc,32*256+98h
                otir
                add   hl,de
                dec   a
                jr nz,1B
                ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; NPC update
;

                include "npc_update.asm"

                include "stack.asm"
                include "npc_init.asm"
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;

                include "collision.asm"
                include "common_code.asm"

                include "music.asm"
                include "gen_maze.asm"
                include "init.asm"


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; MC update
;
                include "mc_update.asm"

mc_dies:        ld     b,50
                call    explode                      ; SFX
1:              push   bc

                call   rand
                ld     b,a
                ld     c,7
                call   wrtvdp                        ; cycle colors
                halt
                call   explode_loop
                pop    bc
                djnz   1b
                jp      startProgram

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

endProgram:

kbd:            ds    1
room_num:       ds    1
cur_tile0:      ds    1
cur_tile1:      ds    1

MSAT:           ds    128

MC:             NPCS_DATA
NPCs:           ds 31*NPCS_DATA

DIR             equ MC.STATUS


endData:



    END


